/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import dev.tr7zw.skinlayers.render.CustomizableCube;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_630;

public class CustomizableModelPart {
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public boolean visible = true;
    private final List<class_630.class_628> cubes;
    private final Map<String, class_630> children;
    private float[] polygonData = null;
    private int polygonAmount = 0;
    private final int polyDataSize = 23;

    public CustomizableModelPart(List<class_630.class_628> list, List<CustomizableCube> customCubes, Map<String, class_630> map) {
        this.cubes = list;
        this.children = map;
        this.compactCubes(customCubes);
    }

    private void compactCubes(List<CustomizableCube> customCubes) {
        for (CustomizableCube cube : customCubes) {
            this.polygonAmount += cube.polygonCount;
        }
        this.polygonData = new float[this.polygonAmount * 23];
        int offset = 0;
        for (CustomizableCube cube : customCubes) {
            for (int id = 0; id < cube.polygonCount; ++id) {
                CustomizableCube.Polygon polygon = cube.polygons[id];
                class_1160 vector3f = polygon.normal;
                this.polygonData[offset + 0] = vector3f.method_4943();
                this.polygonData[offset + 1] = vector3f.method_4945();
                this.polygonData[offset + 2] = vector3f.method_4947();
                for (int i = 0; i < 4; ++i) {
                    CustomizableCube.Vertex vertex = polygon.vertices[i];
                    this.polygonData[offset + 3 + i * 5 + 0] = vertex.scaledX;
                    this.polygonData[offset + 3 + i * 5 + 1] = vertex.scaledY;
                    this.polygonData[offset + 3 + i * 5 + 2] = vertex.scaledZ;
                    this.polygonData[offset + 3 + i * 5 + 3] = vertex.u;
                    this.polygonData[offset + 3 + i * 5 + 4] = vertex.v;
                }
                offset += 23;
            }
        }
    }

    public void loadPose(class_5603 partPose) {
        this.x = partPose.field_27702;
        this.y = partPose.field_27703;
        this.z = partPose.field_27704;
        this.xRot = partPose.field_27705;
        this.yRot = partPose.field_27706;
        this.zRot = partPose.field_27707;
    }

    public void copyFrom(class_630 modelPart) {
        this.xRot = modelPart.field_3654;
        this.yRot = modelPart.field_3675;
        this.zRot = modelPart.field_3674;
        this.x = modelPart.field_3657;
        this.y = modelPart.field_3656;
        this.z = modelPart.field_3655;
    }

    public class_630 getChild(String string) {
        class_630 modelPart = this.children.get(string);
        if (modelPart == null) {
            throw new NoSuchElementException("Can't find part " + string);
        }
        return modelPart;
    }

    public void setPos(float f, float g, float h) {
        this.x = f;
        this.y = g;
        this.z = h;
    }

    public void setRotation(float f, float g, float h) {
        this.xRot = f;
        this.yRot = g;
        this.zRot = h;
    }

    public void render(class_4587 poseStack, class_4588 vertexConsumer, int i, int j) {
        this.render(poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(class_4587 poseStack, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        if (!this.visible) {
            return;
        }
        poseStack.method_22903();
        this.translateAndRotate(poseStack);
        this.compile(poseStack.method_23760(), vertexConsumer, light, overlay, red, green, blue, alpha);
        for (class_630 modelPart : this.children.values()) {
            modelPart.method_22699(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
        poseStack.method_22909();
    }

    public void translateAndRotate(class_4587 poseStack) {
        poseStack.method_22904((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            poseStack.method_22907(class_1160.field_20707.method_23626(this.zRot));
        }
        if (this.yRot != 0.0f) {
            poseStack.method_22907(class_1160.field_20705.method_23626(this.yRot));
        }
        if (this.xRot != 0.0f) {
            poseStack.method_22907(class_1160.field_20703.method_23626(this.xRot));
        }
    }

    private void compile(class_4587.class_4665 pose, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        class_1159 matrix4f = pose.method_23761();
        class_4581 matrix3f = pose.method_23762();
        class_1160 vector3f = new class_1160();
        class_1162 vector4f = new class_1162();
        for (int id = 0; id < this.polygonData.length; id += 23) {
            vector3f.method_4949(this.polygonData[id + 0], this.polygonData[id + 1], this.polygonData[id + 2]);
            vector3f.method_23215(matrix3f);
            for (int o = 0; o < 4; ++o) {
                vector4f.method_23851(this.polygonData[id + 3 + o * 5 + 0], this.polygonData[id + 3 + o * 5 + 1], this.polygonData[id + 3 + o * 5 + 2], 1.0f);
                vector4f.method_22674(matrix4f);
                vertexConsumer.method_23919(vector4f.method_4953(), vector4f.method_4956(), vector4f.method_4957(), red, green, blue, alpha, this.polygonData[id + 3 + o * 5 + 3], this.polygonData[id + 3 + o * 5 + 4], overlay, light, vector3f.method_4943(), vector3f.method_4945(), vector3f.method_4947());
            }
        }
        for (class_630.class_628 cube : this.cubes) {
            cube.method_32089(pose, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }
}

